/*****************************************************************************
*  LPC4357 SCT demo
*
*  Use L counter part to generate a 50 KHz PWM signal at SCT_OUT0
*****************************************************************************/
#include "nxp_lpc43xx.h"

void SCT_Init(void)
{
    LPC_SCT->CONFIG |= (1 << 17);                          // two 16-bit timers, auto limit
    LPC_SCT->CTRL_L |= (SystemCoreClock/1000000-1) << 5;   // set prescaler, SCT clock = 1 MHz
                                              
    LPC_SCT->MATCH[0].L     = 20-1;                        // match 0 @ 20/1MHz = 20 usec (50 KHz PWM freq)
    LPC_SCT->MATCHREL[0].L  = 20-1;
    LPC_SCT->MATCH[1].L     = 5;                           // match 1 used for duty cycle (in 20 steps)
    LPC_SCT->MATCHREL[1].L  = 5;

    LPC_SCT->EVENT[0].STATE = 0x00000001;                  // event 0 only happens in state 0
    LPC_SCT->EVENT[0].CTRL  = (0 << 0)  |                  // MATCHSEL[3:0] = related to match 0
                              (1 << 12) |                  // COMBMODE[13:12] = match condition only
                              (1 << 14) |                  // STATELD[14] = STATEV is loaded into state
                              (0 << 15);                   // STATEV[15] = 0

    LPC_SCT->EVENT[1].STATE = 0x00000001;                  // event 1 only happens in state 0
    LPC_SCT->EVENT[1].CTRL  = (1 << 0)  |                  // MATCHSEL[3:0] = related to match 1
                              (1 << 12) |                  // COMBMODE[13:12] = match condition only
                              (1 << 14) |                  // STATELD[14] = STATEV is loaded into state
                              (0 << 15);                   // STATEV[15] = 0

    LPC_SCT->OUT[0].SET     = (1 << 0);                    // event 0 will set SCT_OUT_0
    LPC_SCT->OUT[0].CLR     = (1 << 1);                    // event 1 will clear SCT_OUT_0

    LPC_SCT->CTRL_L        &= ~(1 << 2);                   // unhalt it by clearing bit 2 of CTRL reg
}
